statemachine class W3MagicDreamer extends CGameplayEntity
{
	var active										: bool;
	var hand_effects_active							: bool;
	var hand_effects								: name;
	var currentsign									: ESignType;
	var original_setting							: bool;
	var should_revert_setting						: bool;
	var swordless_state_name						: name;
	var swordless_spell_name						: name;
	var sett 										: SAnimatedComponentSlotAnimationSettings;
	var leftanim									: bool;
	var can_cast_swordless_animation				: bool;
	var can_cast_swordless_guard					: bool;
	var actor, actor_ag								: CActor;
	var actor_init                                  : CActor;
	var apply_item_hack								: bool;

	event OnDestroyed()
	{
	}
	event OnSpawned( spawnData : SEntitySpawnData )
	{
	}
	
	function init_swordless_spells()
	{
		should_revert_setting = false;
		active = true;
		//theGame.witcherLog.AddMessage("SWORDLESS INIT   "  );
		
		register_swordless_input_spells();
		
		original_setting = theGame.GetInGameConfigWrapper().GetVarValue('Gameplay', 'DisableAutomaticSwordSheathe');
		if ( !original_setting )
		{
			theGame.GetInGameConfigWrapper().SetVarValue('Gameplay', 'DisableAutomaticSwordSheathe', "true" );
			should_revert_setting = true;
		}
		
		GotoState('Dreamer_Waiting');
	}
	
	event OnSwordless_Dodge( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_Dodge");
		
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			if ( GetMagicVigil().is_in_custom_anim )
			{
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				PushState('Dreamer_Waiting');
			}
			
			GetMagicVigil().AddTimer( 'spells_dodge', 0.01f);
		}
	}
	
	event OnSwordless_Roll( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_Roll");
		
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			if ( GetMagicVigil().is_in_custom_anim )
			{
				thePlayer.GetRootAnimatedComponent().PlaySlotAnimationAsync( '', 'PLAYER_SLOT' );
				PushState('Dreamer_Waiting');
			}
			
			GetMagicVigil().AddTimer( 'spells_roll', 0.01f);
		}
	}
	
	event OnSwordless_Guard( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_Guard");
		
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			
			if ( thePlayer.GetBehaviorVariable ( 'IsCastingSign' ) == 0 && thePlayer.GetBIsInputAllowed() && !GetWitcherPlayer().IsCastingSign() && can_cast_swordless_guard ) 
			{
				swordless_state_name = 'Swordless_guard';
				swordless_spell_name = 'guard_spell';
				PushState( 'Dreamer_Casting' );
			}
		}
	}
	
	event OnSwordless_AttackLight( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_AttackLight");
			
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			
			if ( can_cast_swordless( false ) )
			{
				swordless_state_name = 'Swordless_AttackLight';
				PushState( 'Dreamer_Casting' );
			}
		}
	}
	event OnSwordless_AttackLight2( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_AttackLight");
			
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			
			if ( can_cast_swordless( false ) )
			{
				swordless_state_name = 'Swordless_AttackLight';
				PushState( 'Dreamer_Casting' );
			}
		}
	}
	
	
	event OnSwordless_AttackHeavy( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_AttackHeavy");
			
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			
			if ( can_cast_swordless( true ) )
			{
				swordless_state_name = 'Swordless_AttackHeavy';
				PushState( 'Dreamer_Casting' );
			}
		}
	}
	event OnSwordless_AttackHeavy2( action : SInputAction )
	{
		if ( IsPressed(action) )
		{
			//theGame.witcherLog.AddMessage("Swordless_AttackHeavy");
			
			if ( GetMagicVigil().alternate )
			{
				GetMagicVigil().PushState( 'Vigil_Dreaming' );
			}
			
			if ( can_cast_swordless( true ) )
			{
				swordless_state_name = 'Swordless_AttackHeavy';
				PushState( 'Dreamer_Casting' );
			}
		}
	}
	
	timer function raise_event_hack_start( deltaTime : float , id : int)
	{
		thePlayer.SetBehaviorVariable( 'SelectedItemL', (int)UI_Torch, true );	
		thePlayer.RaiseEvent( 'ItemUseL' );
		thePlayer.SetUsableItemLtransitionAllowed ( false );
		apply_item_hack = true;
	}
	
	timer function raise_event_hack_end( deltaTime : float , id : int)
	{
		thePlayer.RaiseEvent('ItemEndL');
		apply_item_hack = false;
	}
	
	timer function rotate_towards_target_swordless( deltaTime : float , id : int)
	{
		var movementAdjustor 														: CMovementAdjustor;
		var ticket_spell	 														: SMovementAdjustmentRequestTicket;	
		var tmpactor																: CActor;
		
		tmpactor = (CActor)thePlayer.GetDisplayTarget();
		
		if ( tmpactor && ( thePlayer.IsThreat(tmpactor) || tmpactor.IsKnockedUnconscious() ) )
		{
			actor = tmpactor;
		}
		
		if ( actor_ag )
		{
			actor = actor_ag;
		}
		
		if ( actor )
		{
			movementAdjustor = thePlayer.GetMovingAgentComponent().GetMovementAdjustor();
			ticket_spell = movementAdjustor.CreateNewRequest( 'Spells_rotation_swordless');
			movementAdjustor.MaxRotationAdjustmentSpeed( ticket_spell, 750 );
			movementAdjustor.MaxLocationAdjustmentSpeed( ticket_spell, 750 );
			movementAdjustor.RotateTowards( ticket_spell, actor );
		}
	}
	
	timer function find_target_ag( deltaTime : float , id : int)
	{
		var movementAdjustor 														: CMovementAdjustor;
		var ticket_spell	 														: SMovementAdjustmentRequestTicket;	
		var tmpactor																: CActor;
		
		tmpactor = (CActor)thePlayer.GetDisplayTarget();
		
		if ( tmpactor && ( thePlayer.IsThreat(tmpactor) || tmpactor.IsKnockedUnconscious() ) )
		{
			actor_ag = tmpactor;
		}
		
		if ( actor_ag )
		{
			RemoveTimer('find_target_ag');
		}
	}
	
	function swordless_hand_effects()
	{
		if ( hand_effects_active && GetMagicVigil().dodge_lock )
		{
			GetMagicEffectLeft().DestroyEffect( hand_effects );
			GetMagicEffectRight().DestroyEffect( hand_effects );
			hand_effects_active = false;
		}
	
		if ( currentsign != GetWitcherPlayer().GetEquippedSign() )
		{
			hand_effects_active = false;
			GetMagicEffectLeft().StopEffect( hand_effects );
			GetMagicEffectRight().StopEffect( hand_effects );
		}
		currentsign = GetWitcherPlayer().GetEquippedSign();
		
		if ( !hand_effects_active && !GetMagicVigil().dodge_lock )
		{
			switch( currentsign )
			{
				case ST_Igni:
					{
						hand_effects = 'swordless_igni';
					}
					break;
			
				case ST_Axii:
					{
						hand_effects = 'swordless_axii';
					}
					break;
				
				case ST_Aard:
					{
						hand_effects = 'swordless_aard';
					}
					break;
				
				case ST_Quen:
					{
						hand_effects = 'swordless_quen';
					}
					break;
				
				case ST_Yrden:
					{
						hand_effects = 'swordless_yrden';
					}
					break;
					
				default:		
					break;
			}
			
			GetMagicEffectLeft().PlayEffect( hand_effects );
			GetMagicEffectRight().PlayEffect( hand_effects );
			hand_effects_active = true;
		}
	}
}


function can_cast_swordless( heavy : bool ) : bool
{
	if ( thePlayer.GetStat( BCS_Stamina ) >= calc_stamina_swordless_spells( heavy ) && thePlayer.GetBehaviorVariable ( 'IsCastingSign' ) == 0  )
	{
		if ( thePlayer.GetBIsInputAllowed() && !GetWitcherPlayer().IsCastingSign() && GetMagicDreamer().can_cast_swordless_animation ) 
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

function calc_stamina_swordless_spells( heavy : Bool, optional sign : ESignType ) : Float
{
	var value 		: Float;
	var sign_type  	: ESignType;

	if ( !heavy )
	{
		value = 7;
	}
	else
	{
		value = 15;
	}
	
	if ( sign != ST_None)
	{
		sign_type = sign;
	}
	else
	{
		sign_type = GetWitcherPlayer().GetEquippedSign();
	}
	switch( sign_type )
	{
		case ST_Igni:
			{
				if ( !heavy )
				{
				}
				else
				{
					value = 4;
				}
			}
			break;
	
		case ST_Axii:
			{
				if ( !heavy )
				{
				}
				else
				{
					value = 25;
				}
			}
			break;
		
		case ST_Aard:
			{
				if ( !heavy )
				{
				}
				else
				{
					value = 4;
				}
			}
			break;
		
		case ST_Quen:
			{
				if ( !heavy )
				{
				}
				else
				{
					value = 25;
				}
			}
			break;
		
		case ST_Yrden:
			{
				if ( !heavy )
				{
				}
				else
				{
				}
			}
			break;
			
		default:		
			break;
	}
	
	value += value * get_stamina_cost_mult_swordless(); 
	
	return value;
}

function drain_stamina_swordless_spells( sign : ESignType, heavy : Bool )
{
	var value : Float;
	var delay : Float;
	var focus : SAbilityAttributeValue;
	
	//delay = 0.5;

	if ( !heavy )
	{
		delay = 1;
	}
	else
	{
		delay = 3;
	}
	
	delay += delay * get_stamina_delay_mult_swordless(); 
	
	GetWitcherPlayer().DrainStamina( ESAT_FixedValue, calc_stamina_swordless_spells( heavy, sign ), delay );
	
	focus = thePlayer.GetAttributeValue('focus_gain');
	if ( thePlayer.CanUseSkill(S_Sword_s20) )
	{
		focus += thePlayer.GetSkillAttributeValue(S_Sword_s20, 'focus_gain', false, true) * thePlayer.GetSkillLevel(S_Sword_s20);
	}
	thePlayer.GainStat(BCS_Focus, 0.1f * (1 + CalculateAttributeValue(focus)) );	
	
	thePlayer.SetCombatIdleStance( 1.f );
}


function deal_damage_swordless_spells( sign : ESkill, victim : CActor, dmg_mult : Float, damageName : name, heavy : Bool )
{
	var dmg_action                  : W3DamageAction;
	var spellpower 					: SAbilityAttributeValue;
	var damage, MULT				: Float;
	var victimsand					: CNewNPC;	
	var fxEntity					: CEntity;
	var chance						: Float;
	var dmgtype_mult				: Float;
	
	if ( !theSound.SoundIsBankLoaded("ep2_mutations_02.bnk") )
	{
		theSound.SoundLoadBank( "ep2_mutations_02.bnk", false );
	}
	
	victimsand = (CNewNPC)victim;
	
	dmg_action = new W3DamageAction in NULL;
	dmg_action.Initialize(thePlayer,victim,NULL,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
	dmg_action.SetProcessBuffsIfNoDamage(true);
	
	dmg_action.SetHitReactionType(EHRT_None, false);
	
	dmg_action.SetHitEffect('');
	dmg_action.SetHitEffect('', true );
	dmg_action.SetHitEffect('', false, true);
	dmg_action.SetHitEffect('', true, true);
	
	MULT = get_player_level_swordless();
	
	if ( dmg_mult != 0 )
	{
		if ( !heavy )
		{
			dmg_mult = MULT;
			chance = 0.2;
			if ( sign == S_Magic_5 )
			{
				//dmg_action.AddEffectInfo( EET_Stagger );
				dmg_action.SetHitReactionType(EHRT_Heavy);
			}
			if ( sign == S_Magic_1 )
			{
				//dmg_action.AddEffectInfo( EET_Stagger );
				dmg_action.SetHitReactionType(EHRT_Light);
				//dmg_mult *= 1.2;
			}
			else
			{
				if( RandF() <= 0.3 )
				{
					dmg_action.SetHitReactionType(EHRT_Light);
				}
			}
		}
		else
		{
			dmg_mult = MULT * 1.6 ;
			chance = 0.4;
			dmg_action.SetHitReactionType(EHRT_Heavy);
			
			if ( sign == S_Magic_3 || sign == S_Magic_5 )
			{
				//dmg_action.AddEffectInfo( EET_Stagger );
			}
		}
		
		if ( sign == S_Magic_4 && heavy )
		{
			dmg_action.SetHitReactionType( EHRT_None );
			dmg_mult = MULT * 0.4 ;
		}
		if ( sign == S_Magic_1 && heavy )
		{
			dmg_mult = MULT * 0.4 ;
			dmg_action.SetHitReactionType( EHRT_Heavy );
			//if ( !victim.HasBuff( EET_Stagger ) )
			//{
				//dmg_action.AddEffectInfo( EET_Stagger );
			//}
		}
		if ( sign == S_Magic_2 && heavy )
		{
			chance = 0.05;
			dmg_mult = MULT * 0.4 ;
			dmg_action.SetHitReactionType( EHRT_Heavy );
			//if ( !victim.HasBuff( EET_Stagger ) )
			//{
				//dmg_action.AddEffectInfo( EET_Stagger );
			//}
		}
	}
	
	damage = thePlayer.GetLevel()*dmg_mult;
	damage += damage * get_spellpower_spells( false, sign) * get_spellpower_mult();
	damage += damage * get_overall_mult();
	
	if(	!victim.IsHuman() && !victim.IsAnimal()	)
	{	
		damage += damage * get_monsters_mult();
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
	{
		damage *= RandRangeF(1.1, 0.9);
	}
	
	if( RandF() <= chance )
	{
		if ( damageName == theGame.params.DAMAGE_NAME_FORCE )
		{	
			if ( !heavy )
			{
				dmg_action.SetHitReactionType(EHRT_None);
				dmg_action.AddEffectInfo( EET_Knockdown, ( spellpower.valueMultiplicative+1 ) * 2 );  
			}
		}
	
		if ( damageName == theGame.params.DAMAGE_NAME_FIRE )
		{	
			if ( !victim.HasBuff( EET_Burning ) )
			{
				if ( heavy )
				{
					dmg_action.victim.PlayEffect('fire_hit');
				}
				dmg_action.AddEffectInfo( EET_Burning, 1.5 );  
			}
		}
		
		if ( damageName == theGame.params.DAMAGE_NAME_FROST )
		{	
			if ( !heavy )
			{
				dmg_action.AddEffectInfo( EET_SlowdownFrost, 3 );  
			}
			else
			{
				if ( RandF() <= 0.5 )
				{
					dmg_action.AddEffectInfo( EET_SlowdownFrost, 4 );  
				}
				else
				{
					dmg_action.AddEffectInfo( EET_Frozen, 	3 ); 
				}
			}
		}
	}
	
	/*
	if ( heavy || RandF() <= 0.1 )
	{
		dmg_action.SetForceExplosionDismemberment();
	}
	*/
	
	if ( spells_can_dismember( victim ) )
	{
		dmg_action.SetForceExplosionDismemberment();
	}
	
	if ( damageName == theGame.params.DAMAGE_NAME_FROST )
	{			dmgtype_mult = sp_frost_dmg_mod();		}
	if ( damageName == theGame.params.DAMAGE_NAME_SHOCK )
	{			dmgtype_mult = sp_shock_dmg_mod();		}
	if ( damageName == theGame.params.DAMAGE_NAME_FORCE )
	{			dmgtype_mult = sp_force_dmg_mod();		}
	if ( damageName == theGame.params.DAMAGE_NAME_FIRE  )
	{			dmgtype_mult = sp_fire_dmg_mod();		}
	
	dmg_action.AddDamage( damageName, damage * dmgtype_mult );
	
	theGame.damageMgr.ProcessAction( dmg_action );
	delete dmg_action;
	
	if( !victim.IsAlive() )
	{
		if ( sign == S_Magic_1 )
		{
			if ( heavy )
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'swordless_hits', true );
				fxEntity.PlayEffect( 'hit_aard_proj' );
				fxEntity.PlayEffect( 'hit_aard_proj2' );
				fxEntity.PlayEffect( 'hit_aard_proj_f' );
				fxEntity.StopEffect( 'hit_aard_proj_f' );
				fxEntity.SoundEvent("ep2_mutations_02_critical_death");
				fxEntity.DestroyAfter(5);
			}
			else
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'swordless_hits', true );
				fxEntity.PlayEffect( 'hit_aard_proj2' );
				fxEntity.SoundEvent("ep2_mutations_02_critical_hit");
				fxEntity.DestroyAfter(5);
			}
		}
		
		if ( sign == S_Magic_3 )
		{
			if ( heavy )
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'mutation_2_explode', false );
				fxEntity.PlayEffect( 'mutation_2_yrden' );
				fxEntity.DestroyAfter(5);
			}
			else
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'mutation2_critical', true );
				fxEntity.PlayEffect( 'critical_yrden' );
				fxEntity.DestroyAfter(5);
			}
		}
		if ( sign == S_Magic_2 )
		{
			if ( heavy )
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'mutation_2_explode', false );
				fxEntity.PlayEffect( 'mutation_2_igni' );
				fxEntity.DestroyAfter(5);
			}
			else
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'mutation2_critical', true );
				fxEntity.PlayEffect( 'critical_igni' );
				fxEntity.DestroyAfter(5);
			}
		}
		if ( sign == S_Magic_4 )
		{
			if ( heavy )
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'mutation_2_explode', false );
				fxEntity.PlayEffect( 'mutation_2_quen' );
				fxEntity.DestroyAfter(5);
			}
			else
			{
				fxEntity = victim.CreateFXEntityAtPelvis( 'mutation2_critical', true );
				fxEntity.PlayEffect( 'critical_quen' );
				fxEntity.DestroyAfter(5);
			}
		}
	}
}
